'use strict';
(function ($) {

    $(document).ready(function () {
        $('.ajax_button').on('click', async function (e) {
            e.preventDefault();
            const button = $(this);
            const confirmText = button.data('confirm');
            const originalText = button.html();
            const action = button.data('action');
            const successMessage = button.data('success-msg') || 'Operation completed successfully.';

            if (typeof confirmText === 'string' && confirmText.trim() !== '') {
                const confirmed = await showConfirmation(confirmText.trim());
                if (!confirmed) return;
            }
            button.prop('disabled', true);
            button.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...');

            $.ajax({
                'url': fdgames_params?.ajax_url || '/wp-admin/admin-ajax.php',
                'method': 'POST',
                'dataType': 'json',
                'data': {
                    action: action,
                },
                'success': function (r) {
                    let noticeType = 'success';
                    if (
                        (r?.data?.games_import?.status === 'warning') ||
                        (r?.data?.vendors_import?.status === 'warning')
                    ) {
                        noticeType = 'warning';
                    }

                    let message =
                        r?.data?.games_import?.msg ??
                        r?.data?.vendors_import?.msg ??
                        successMessage;
                    showNotice(noticeType, message);
                    console.log(r);
                },
                'error': function (xhr) {
                    showNotice('danger',
                        'Something went wrong. Please try again. If the error persists, please contact the FreeDemo.Games team.'
                    );
                    console.log(xhr);
                },
                'complete': function () {
                    button.prop('disabled', false);
                    button.html(originalText);
                }
            });
        });
    });

    function showConfirmation(text) {
        return new Promise((resolve) => {
            const modalEl = document.getElementById('fdg-confirm-modal');
            const modalText = modalEl.querySelector('#fdg-confirm-modal-text');
            const confirmBtn = modalEl.querySelector('#fdg-modal-confirm-btn');

            modalText.textContent = text;

            const modal = new bootstrap.Modal(modalEl);
            modal.show();

            const handleConfirm = () => {
                confirmBtn.removeEventListener('click', handleConfirm);
                resolve(true);
                modal.hide();
            };

            confirmBtn.addEventListener('click', handleConfirm);

            modalEl.addEventListener('hidden.bs.modal', function onClose() {
                modalEl.removeEventListener('hidden.bs.modal', onClose);
                confirmBtn.removeEventListener('click', handleConfirm);
                resolve(false);
            });
        });
    }

    function showNotice(type = 'success', message = '') {
        const alertHtml = `
            <div class="notice freedemo-games-notice notice-${type} fade show" role="alert">
                ${message}
            </div>
        `;

        $('#fdgames-settings').prepend(alertHtml);
    }
})(jQuery)
