<?php

/**
 * Freedemo Games plugin
 *
 * @link              https://freedemo.games/
 * @since             1.0.3
 * @package           freedemo-games/free-games
 * @wordpress-plugin
 * Plugin Name:       Freedemo.games
 * Plugin URI:        https://freedemo.games/
 * Description:       Free demo games for online casino affiliates.
 * Version:           1.0.3
 * Author:            Freedemo games
 * Author URI:        https://freedemo.games/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       freedemo-games
 * Domain Path:       /languages
 * Update URI:        https://freedemo.games/
 */

use FreedemoGames\Core\Kernel;
use FreedemoGames\Core\Activator;
use FreedemoGames\Core\Deactivator;

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

if (!file_exists(__DIR__ . '/vendor/autoload.php')) {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p>';
        echo 'The <strong>Freedemo Games</strong> plugin cannot be started because the file <code>vendor/autoload.php</code> is missing. Please run <code>composer install</code>.';
        echo '</p></div>';
    });

    return; // stop plugin initialization
}
require_once __DIR__ . '/vendor/autoload.php';

// General
const FREEDEMOGAMES_VERSION            = '1.0.0';
const FREEDEMOGAMES_SETTINGS_KEY       = 'fdgames_settings';
const FREEDEMOGAMES_CURRENT_REPOSITORY = 'local';

// Paths
define('FREEDEMOGAMES_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FREEDEMOGAMES_PLUGIN_URL', plugin_dir_url(__FILE__));
const FREEDEMOGAMES_PLUGIN_FILE = __FILE__;

// Host API/Widget
const FREEDEMOGAMES_DEFAULT_API_HOST        = 'https://api.freedemo.games';
const FREEDEMOGAMES_WIDGET_DEFAULT_BASE_SRC = 'https://api.freedemo.games/assets/widget/v1/js/game.widget.js';

define('FREEDEMOGAMES_DEFAULT_API_TAG', sprintf('wp-plugin/v:%s', FREEDEMOGAMES_VERSION));
define('FREEDEMOGAMES_API_HOST', getenv('FREEDEMOGAMES_API_HOST') ?: FREEDEMOGAMES_DEFAULT_API_HOST);
define('FREEDEMOGAMES_WIDGET_SRC', (getenv('FREEDEMOGAMES_WIDGET_SRC') ?: FREEDEMOGAMES_WIDGET_DEFAULT_BASE_SRC) . '?v=' . gmdate('Ymd-H'));

// Register install and uninstall hooks
register_activation_hook(__FILE__, [Activator::class, 'activate']);
register_deactivation_hook(__FILE__, [Deactivator::class, 'deactivate']);

/**
 * Run plugin
 */
add_action('plugins_loaded', function () {
    Kernel::getInstance(is_admin());
});
