<?php

namespace FreedemoGames\Admin;

use FreedemoGames\Core\GamesImporterService;
use FreedemoGames\Core\ProvidersImporterService;

/**
 * Class AdminAjaxController
 *
 * @package FreedemoGames\Admin
 */
class AdminAjaxController
{
    private GamesImporterService     $gamesImporterService;
    private ProvidersImporterService $vendorsImporterService;
    private array                    $response = [];

    public function __construct(
        GamesImporterService $gamesImporterService,
        ProvidersImporterService $vendorsImporterService
    ) {
        $this->gamesImporterService   = $gamesImporterService;
        $this->vendorsImporterService = $vendorsImporterService;
    }

    public function init(): void
    {
        add_action('wp_ajax_fdgames_install_resources', [$this, 'install_resources']);
    }

    public function install_resources(): void
    {
        ignore_user_abort(true);
        @set_time_limit(0);
        ini_set('max_execution_time', 0);

        $this->install_vendors_start();
        $this->install_games_start();
        wp_send_json_success($this->response);
    }

    public function install_vendors_start(): void
    {
        $this->response['vendors_import'] = $this->vendorsImporterService->import();
        wp_reset_postdata();
    }

    /**
     * @return void
     */
    public function install_games_start(): void
    {
        $this->response['games_import'] = $this->gamesImporterService->import();
        wp_reset_postdata();
    }
}
