<?php

namespace FreedemoGames\Admin;

/**
 * Class Notices
 *
 * @package FreedemoGames\Admin
 */
class Notices
{
    private static $_instance = null;

    public $notices = [];

    public static function getInstance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function __construct()
    {
        add_action('admin_notices', [$this, 'display']);
    }

    public function display()
    {
        echo implode(' ', $this->notices);
    }

    public static function add($message, $type = '')
    {
        $instance = self::getInstance();
        $id       = 'freedemo-games-notice-' . (count($instance->notices) + 1);
        $type     = !empty($type) ? 'notice-' . $type : '';
        $notice   = sprintf(
            '<div class="notice freedemo-games-notice %s" id="%s">%s</div>',
            $type,
            $id,
            wpautop($message)
        );

        $instance->notices[] = $notice;
    }

    public static function info($message)
    {
        self::add($message, 'info');
    }

    public static function error($message)
    {
        self::add($message, 'error');
    }

    public static function success($message)
    {
        self::add($message, 'success');
    }

    public static function warning($message)
    {
        self::add($message, 'warning');
    }
}
