<?php

namespace FreedemoGames\Admin\PostCustomType;

use FreedemoGames\Admin\PostCustomType\Types\RegisterTypeInterface;

/**
 * Special custom post type for slots
 * Class CustomTypesManager
 *
 * @package FreedemoGames\Core\PostCustomType
 */
class CustomTypesManager
{
    private array $post_types;

    public function __construct(RegisterTypeInterface ...$post_types)
    {
        $this->post_types = $post_types;
    }

    /**
     * @return void
     */
    public function init(): void
    {
        foreach ($this->post_types as $post_types) {
            $post_types->register_type();
        }
    }
}
