<?php

declare(strict_types = 1);

namespace FreedemoGames\Admin\PostCustomType\Types;

use FreedemoGames\Admin\AdminController;

/**
 * Class FreedemoFiltersTaxonomy
 *
 * @package FreedemoGames\Admin\PostCustomType\Types
 */
class FreedemoFiltersTaxonomy implements RegisterTypeInterface
{
    const TYPE_NAME = 'fdg-filter';

    public function register_type(): void
    {
        $labels = [
            'name'              => _x('Filter', 'taxonomy general name', 'freedemo-games'),
            'singular_name'     => _x('Filter', 'taxonomy singular name', 'freedemo-games'),
            'menu_name'         => __('Filter', 'freedemo-games'),
            'parent_item_colon' => __('Parent Filter:', 'freedemo-games'),
            'all_items'         => __('All Filters', 'freedemo-games'),
            'add_new_item'      => __('Add New Filter', 'freedemo-games'),
            'edit_item'         => __('Edit Filter', 'freedemo-games'),
            'update_item'       => __('Update Filter', 'freedemo-games'),
            'search_items'      => __('Search Filters', 'freedemo-games'),
            'parent_item'       => __('Parent Filter', 'freedemo-games'),
            'new_item_name'     => __('New Filter Name', 'freedemo-games'),
        ];

        $args = [
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => false,
            'show_admin_column' => false,
            'public'            => false,
            'show_in_menu'      => AdminController::MAIN_PLUGIN_SETTING_SLUG,
            'query_var'         => true,
            'rewrite'           => ['slug' => 'slot-filter'],
        ];
        register_taxonomy(
            self::TYPE_NAME,
            [FreedemoPostGameType::TYPE_NAME],
            apply_filters('fdgames/register_taxonomy/' . self::TYPE_NAME, $args)
        );
    }
}
