<?php

namespace FreedemoGames\Admin\PostCustomType\Types;

use FreedemoGames\Admin\AdminController;

use function FreedemoGames\fdg_setting;

/**
 * Class FreedemoPostGameType
 *
 * @package FreedemoGames\Core\PostCustomType\Types
 */
class FreedemoPostGameType implements RegisterTypeInterface
{
    const TYPE_NAME = 'fdgames';

    public function register_type(): void
    {
        $labels = [
            'name'               => _x('Games', 'Post Type General Name', 'freedemo-games'),
            'singular_name'      => _x('Game', 'Post Type Singular Name', 'freedemo-games'),
            'menu_name'          => __('Games', 'freedemo-games'),
            'parent_item_colon'  => __('Parent Game', 'freedemo-games'),
            'all_items'          => __('All Games', 'freedemo-games'),
            'add_new_item'       => __('Add New Game', 'freedemo-games'),
            'edit_item'          => __('Edit Game', 'freedemo-games'),
            'update_item'        => __('Update Game', 'freedemo-games'),
            'search_items'       => __('Search Game', 'freedemo-games'),
            'add_new'            => __('Add New', 'freedemo-games'),
            'view_item'          => __('View Game', 'freedemo-games'),
            'not_found'          => __('Not Found', 'freedemo-games'),
            'not_found_in_trash' => __('Not found in Trash', 'freedemo-games'),
        ];

        $args = [
            'hierarchical'        => false, // true = like pages with parent and child, false = post
            'label'               => __('Slots', 'freedemo-games'),
            'public'              => true,
            'show_in_menu'        => AdminController::MAIN_PLUGIN_SETTING_SLUG,
            'show_in_nav_menus'   => true,
            'show_ui'             => true,
            'description'         => __('Game news and reviews', 'freedemo-games'),
            'labels'              => $labels,
            'supports'            => [
                'title',
                'editor',
                'excerpt',
                'author',
                'thumbnail',
                'comments',
                'revisions',
                'custom-fields',
            ],
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => false,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest'        => true,
            'rewrite'             => [
                'slug' => fdg_setting('slots-slug', 'slots'),
            ],
        ];

        register_post_type(
            self::TYPE_NAME,
            apply_filters('fdgames/register_post_type/' . self::TYPE_NAME, $args)
        );
    }
}
