<?php

declare(strict_types = 1);

namespace FreedemoGames\Admin\PostCustomType\Types;

use FreedemoGames\Admin\AdminController;

/**
 * Class FreedemoProviderTaxonomy
 *
 * @package FreedemoGames\Core\PostCustomType\Types
 */
class FreedemoProviderTaxonomy implements RegisterTypeInterface
{
    const TYPE_NAME = 'fdg-provider';

    public function register_type(): void
    {
        $labels = [
            'name'              => _x('Provider', 'taxonomy general name', 'freedemo-games'),
            'singular_name'     => _x('Provider', 'taxonomy singular name', 'freedemo-games'),
            'menu_name'         => __('Provider', 'freedemo-games'),
            'parent_item_colon' => __('Parent Provider:', 'freedemo-games'),
            'all_items'         => __('All Providers', 'freedemo-games'),
            'add_new_item'      => __('Add New Provider', 'freedemo-games'),
            'edit_item'         => __('Edit Provider', 'freedemo-games'),
            'update_item'       => __('Update Provider', 'freedemo-games'),
            'search_items'      => __('Search Providers', 'freedemo-games'),
            'parent_item'       => __('Parent Provider', 'freedemo-games'),
            'new_item_name'     => __('New Provider Name', 'freedemo-games'),
        ];

        $args = [
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'public'            => false,
            'show_in_menu'      => AdminController::MAIN_PLUGIN_SETTING_SLUG,
            'query_var'         => true,
            'rewrite'           => ['slug' => 'slot-provider'],
        ];

        register_taxonomy(
            self::TYPE_NAME,
            [FreedemoPostGameType::TYPE_NAME],
            apply_filters('slotsl/register_taxonomy/' . self::TYPE_NAME, $args)
        );
    }
}
