<?php

namespace FreedemoGames\Admin\PostCustomType\Types;

use FreedemoGames\Admin\AdminController;

/**
 * Class FreedemoTypeTaxonomy
 *
 * @package FreedemoGames\Admin\PostCustomType\Types
 */
class FreedemoTypeTaxonomy implements RegisterTypeInterface
{
    const TYPE_NAME = 'fdg-type';

    public function register_type(): void
    {
        $labels = [
            'name'              => _x('Type', 'taxonomy general name', 'freedemo-games'),
            'singular_name'     => _x('Type', 'taxonomy singular name', 'freedemo-games'),
            'menu_name'         => __('Type', 'freedemo-games'),
            'parent_item_colon' => __('Parent Type:', 'freedemo-games'),
            'all_items'         => __('All Types', 'freedemo-games'),
            'add_new_item'      => __('Add New Type', 'freedemo-games'),
            'edit_item'         => __('Edit Type', 'freedemo-games'),
            'update_item'       => __('Update Type', 'freedemo-games'),
            'search_items'      => __('Search Types', 'freedemo-games'),
            'parent_item'       => __('Parent Type', 'freedemo-games'),
            'new_item_name'     => __('New Type Name', 'freedemo-games'),
        ];

        $args = [
            'hierarchical'      => true,
            'labels'            => $labels,
            'public'            => false,
            'show_in_menu'      => AdminController::MAIN_PLUGIN_SETTING_SLUG,
            'query_var'         => true,
            'show_in_nav_menus' => true,
            'show_ui'           => true,
            'show_in_rest'      => true,
            'show_admin_column' => true,
            'rewrite'           => ['slug' => 'slot-type'],
        ];

        register_taxonomy(
            self::TYPE_NAME,
            [FreedemoPostGameType::TYPE_NAME],
            apply_filters('fdgames/register_taxonomy/' . self::TYPE_NAME, $args)
        );
    }
}
