<?php

namespace FreedemoGames\Admin;

use FreedemoGames\Core\Render;

/**
 * Class SettingsFields
 *
 * @package FreedemoGames\Admin
 */
class SettingsFields
{
    /**
     * @param string $view
     *
     * @return mixed
     */
    public static function get_predefined_settings(string $view = '')
    {
        $all = [
            'general' => [
                'slots-heading' => [
                    'id'       => 'slots-heading',
                    'content'  => '<h4>' . esc_html__('General slots settings', 'freedemo-games') . '</h4>',
                    'type'     => 'content',
                    'no_label' => true,
                    'class'    => [],
                ],
                'slots-slug'    => [
                    'id'          => 'slots-slug',
                    'name'        => esc_html__('Url Slug', 'freedemo-games'),
                    'desc'        => esc_html__(
                        'Set the default base slug for single slot game page. For example: yourdoman.com/slots/allways-egypt-fortune/',
                        'freedemo-games'
                    ),
                    'type'        => 'text',
                    'default'     => 'slots',
                    'placeholder' => 'slots',
                ],

                'lobby-url'    => [
                    'id'          => 'lobby-url',
                    'name'        => esc_html__('Lobby url', 'freedemo-games'),
                    'desc'        => esc_html__(
                        'Specify the URL where the [freedemo-games-archive] shortcode is used to display the list of demo games. This is necessary for correct breadcrumb navigation',
                        'freedemo-games'
                    ),
                    'type'        => 'text',
                    'default'     => site_url('slots'),
                    'placeholder' => site_url('slots'),
                ],
                'fdg-backlink' => [
                    'id'      => 'fdg-backlink',
                    'name'    => esc_html__('Backlink', 'freedemo-games'),
                    'desc'    => esc_html__(
                        'Show backlink',
                        'freedemo-games'
                    ),
                    'type'    => 'checkbox',
                    'default' => true,
                    'visibility' => false,
                ],

                //                'partner-id' => [
                //                    'id'      => 'partner-id',
                //                    'name'    => esc_html__('Partner id', 'freedemo-games'),
                //                    'desc'    => esc_html__(
                //                        'Specify your partner ID. If you don\'t have one, please contact freedemo.games support.',
                //                        'freedemo-games'
                //                    ),
                //                    'type'    => 'number',
                //                    'default' => null,
                //                ],

                'token' => [
                    'id'      => 'token',
                    'name'    => esc_html__('Partner API token', 'freedemo-games'),
                    'desc'    => esc_html__(
                        'Paste the API token issued to your partner account. Keep it secret. If you don’t have one, contact freedemo.games support.',
                        'freedemo-games'
                    ),
                    'type'    => 'text',
                    'default' => null,
                ],

                'install_games' => [
                    'id'          => 'install_games',
                    'name'        => esc_html__('Install / Updates games', 'freedemo-games'),
                    'button_text' => esc_html__('Install games', 'freedemo-games'),
                    'type'        => 'ajax_button',
                    'action'      => 'fdgames_install_resources',
                    'desc'        => esc_html__(
                        'Starts installing or updating providers and games on your site. This may take up to 15 minutes.',
                        'freedemo-games'
                    ),
                    'confirm'     => esc_html__(
                        'Are you sure you want to start the process of installing or updating the games? This may take a while (up to 15 minutes).',
                        'freedemo-games'
                    ),
                    'success_msg' => 'Games installed successfully!',
                ],
            ],
        ];
        $all = apply_filters('fdgames/settings_defaults', $all);

        return empty($view) ? $all : $all[$view];
    }

    /**
     * @param string $field_view
     * @param array  $args
     *
     * @return false|string
     */
    public static function get_settings_field(string $field_view, array $args)
    {
        return Render::render_admin('/partials/settings-fields', $field_view, $args);
    }
}
