<?php

use function FreedemoGames\fdg_setting;

$visibility = (bool)($visibility ?? true);
$id         ??= '';
$name       ??= '';
$default    ??= true;
$value      = fdg_setting($id, $default);
$desc       = $args['desc'] ?? '';
?>
<div class="row mb-4 align-items-start" style="<?= !$visibility ? 'display:none;' : '' ?>">
    <label for="freedemo-games-setting-<?= esc_attr($id); ?>"
           class="col-md-3 col-form-label fw-semibold">
        <?= esc_html($name); ?>
    </label>

    <div class="col-md-9">
        <input type="checkbox"
               class="form-check-input"
               id="freedemo-games-setting-<?= esc_attr($id); ?>"
               name="<?= esc_attr($id); ?>"
            <?= checked($default, $value, false); ?> />
        <?php
        if (!empty($desc)): ?>
            <small class="form-text text-muted"><?= wp_kses_post($desc); ?></small>
        <?php
        endif; ?>
    </div>
</div>
