<?php

use function FreedemoGames\fdg_setting;

$default     = isset($default) ? esc_html($default) : '';
$placeholder = isset($placeholder) ? esc_html($placeholder) : '';
$value       = fdg_setting($id, $default);
$desc        = $args['desc'] ?? '';
?>

<div class="row mb-4 align-items-start">
    <label for="freedemo-games-setting-<?= esc_attr($id); ?>"
           class="col-md-3 col-form-label fw-semibold">
        <?= esc_html($name); ?>
    </label>

    <div class="col-md-9">
        <input type="text"
               class="form-control <?= implode(' ', $class ?? []) ?>"
               id="freedemo-games-setting-<?= esc_attr($id); ?>"
               name="<?= esc_attr($id); ?>"
               placeholder="<?= esc_attr($placeholder); ?>"
               value="<?= esc_attr($value); ?>" />

        <?php if (!empty($desc)): ?>
            <small class="form-text text-muted"><?= wp_kses_post($desc); ?></small>
        <?php endif; ?>
    </div>
</div>
