<?php

use function FreedemoGames\fdg_main_admin_settings_url;

?>

<div id="fdgames-settings" class="wrap freedemo-games-admin-wrap freedemo-games-admin-page container">
    <ul class="nav nav-tabs mb-4 freedemo-games-admin-tabs">
        <?php
        foreach ($tabs as $id => $tab) {
            $active = $id === $view ? 'active' : '';
            $name   = $tab['name'];
            $link   = add_query_arg(
                'view',
                $id,
                fdg_main_admin_settings_url()
            );
            ?>
            <li class="nav-item">
                <a href="<?= esc_url_raw($link) ?>"
                   class="nav-link <?= esc_attr($active) ?>"><?= esc_html($name) ?></a>
            </li>
            <?php
        } ?>
    </ul>

    <div class="freedemo-games-admin-content freedemo-games-admin-settings">
        <form class="freedemo-games-admin-settings-form needs-validation" method="post" novalidate>
            <input type="hidden" name="action" value="update-settings">
            <input type="hidden" name="view" value="<?= esc_attr($view); ?>">
            <input type="hidden" name="nonce" value="<?= wp_create_nonce('fdgames-settings-nonce'); ?>">

            <?php
            do_action('freedemo-games_admin_settings_before', $view, $fields); ?>

            <div class="mb-4">
                <?php
                foreach ($fields as $field) {
                    echo $field;
                }
                ?>
            </div>

            <div class="mb-3">
                <button type="submit"
                        class="btn btn-primary freedemo-games-btn freedemo-games-btn-md freedemo-games-btn-blue"
                        name="fdgames-settings-submit">
                    <?= esc_html($tabs[$view]['submit']); ?>
                </button>
            </div>

            <?php
            do_action('freedemo-games_admin_settings_after', $view, $fields); ?>
        </form>
    </div>
</div>

<div class="modal fade" id="fdg-confirm-modal" tabindex="-1" aria-labelledby="fdg-confirm-label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="fdg-confirm-label">Please confirm</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="fdg-confirm-modal-text">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="fdg-modal-confirm-btn">Yes, proceed</button>
            </div>
        </div>
    </div>
</div>
