<?php

namespace FreedemoGames\Core;

use function FreedemoGames\fdg_settings;

/**
 * Class Activator
 *
 * @package FreedemoGames\Core
 */
class Activator
{
    /**
     * @return void
     */
    public static function activate()
    {
        $settings = fdg_settings();
        if (!$settings) {
            set_transient('fdgames_activator', true, 30);
        }
        // Check PHP version
        $phpversion = phpversion();
        if (version_compare($phpversion, '7.4', '<')) {
            // Deactivate the plugin
            deactivate_plugins(basename(FREEDEMOGAMES_PLUGIN_FILE));
            // Show an error message
            wp_die(
                'Freedemo.games plugin requires PHP version 7.4 or higher. Please update your PHP version to use this plugin.'
            );
        }

        flush_rewrite_rules();
    }
}
