<?php

namespace FreedemoGames\Core;

/**
 * Class ApiClient
 *
 * @package FreedemoGames\Core
 */
class ApiClient
{
    const DEFAULT_API_HOST = 'https://api.freedemo.games';
    const API_VERSION      = 'v1';
    private static HttpClient $http_client;

    public function __construct($host = '', $default_headers = [])
    {
        $api_host          = $host ?: self::DEFAULT_API_HOST;
        self::$http_client = new HttpClient($api_host, $default_headers);
    }

    public static function api_host()
    {
        return apply_filters('fdgames/api_host', self::$http_client->get_host());
    }

    public static function api_version()
    {
        return apply_filters('fdgames/api_version', self::API_VERSION);
    }

    public static function get_providers(array $args, $headers = []): array
    {
        return self::$http_client->get(self::base_export_endpoint('vendors'), $args, $headers);
    }

    public static function get_games(array $args, $headers = []): array
    {
        return self::$http_client->get(self::base_export_endpoint('games'), $args, $headers);
    }

    private static function base_export_endpoint($rest_path = ''): string
    {
        return rtrim(sprintf('/wp-export/%s/%s', self::API_VERSION, $rest_path), '/');
    }
}
