<?php

namespace FreedemoGames\Core;

/**
 * Class ApiResponseWrapper
 *
 * @package FreedemoGames\Core
 */
class ApiResponseWrapper
{
    const STATUS_SUCCESS = 'success';
    const STATUS_ERROR   = 'error';

    public static function wrapper(string $status, string $msg, array $data = [], array $meta = []): array
    {
        $response = [
            'status' => $status,
            'msg'    => $msg,
        ];

        if (!empty($data)) {
            $response = array_merge($response, $data);
        }

        if (!empty($meta)) {
            $response['meta'] = $meta;
        }

        return $response;
    }

    public static function success(string $msg = '', array $data = [], array $meta = []): array
    {
        return self::wrapper(self::STATUS_SUCCESS, $msg, $data, $meta);
    }

    public static function error(string $msg, array $data = [], array $meta = []): array
    {
        return self::wrapper(self::STATUS_ERROR, $msg, $data, $meta);
    }
}
