<?php

declare(strict_types = 1);

namespace FreedemoGames\Core;

use FreedemoGames\Core\GamesSource\Exceptions\InvalidGameArgumentsException;

/**
 * Class GameValidatorService
 *
 * @package FreedemoGames\Core
 */
class GameValidatorService
{
    const REQUIRED_GAME_FIELDS = [
        'fdg_game_id',
        'fdg_vendor_id',
        'fdg_slug',
    ];

    /**
     * @param array $args
     * @param bool  $trow_exception
     *
     * @return bool
     * @throws InvalidGameArgumentsException
     */
    public static function are_there_required_fields(array $args, bool $trow_exception = true): bool
    {
        foreach (self::REQUIRED_GAME_FIELDS as $key) {
            if (!isset($args[$key])) {
                if ($trow_exception) {
                    throw new InvalidGameArgumentsException(
                        sprintf(
                            "Can't create the Game Entity. Required field '%s' is missing or empty.",
                            $key
                        )
                    );
                }

                return false;
            }
        }

        return true;
    }
}
