<?php

namespace FreedemoGames\Core;

use FreedemoGames\PublicSide\PublicSideController;
use FreedemoGames\Core\GamesSource\RepositoryFactory;
use FreedemoGames\Core\GamesSource\Entities\GameEntity;
use FreedemoGames\Core\GamesSource\Dto\GamesCriteriaDto;
use FreedemoGames\Admin\PostCustomType\Types\FreedemoTypeTaxonomy;
use FreedemoGames\Core\GamesSource\Collection\GamesEntityCollection;
use FreedemoGames\Admin\PostCustomType\Types\FreedemoFiltersTaxonomy;
use FreedemoGames\Admin\PostCustomType\Types\FreedemoProviderTaxonomy;
use FreedemoGames\Core\GamesSource\Exceptions\GameDoesntExistException;
use FreedemoGames\Core\GamesSource\Exceptions\InvalidGameArgumentsException;

use function FreedemoGames\fdg_current_page;

/**
 * Class GamesService
 *
 * @package FreedemoGames\Core
 */
class GamesService
{
    /**
     * @throws InvalidGameArgumentsException
     * @throws GameDoesntExistException
     */
    public static function get_game(array $atts = []): GameEntity
    {
        return RepositoryFactory::get_repository()->get_game($atts);
    }

    /**
     * @param array $args
     *
     * @return GamesEntityCollection
     */
    public static function get_games(array $args = []): GamesEntityCollection
    {
        $criteria = new GamesCriteriaDto([
            'type'     => $_GET[FreedemoTypeTaxonomy::TYPE_NAME] ?? '',
            'filters'  => $_GET[FreedemoFiltersTaxonomy::TYPE_NAME] ?? [],
            'search'   => $_GET['fdg-name'] ?? '',
            'provider' => $_GET[FreedemoProviderTaxonomy::TYPE_NAME] ?? '',
            'sort'     => $_GET['fdg-sort'] ?? 'new',
        ]);

        $page    = !empty($_GET['page']) ? max(1, (int)$_GET['page']) : (int)fdg_current_page();
        $perPage = !empty($args['per_page']) ? max(1, (int)$args['per_page']) : PublicSideController::GAMES_PER_PAGE;
        $offset  = ($page - 1) * $perPage;

        $args = array_merge($args, [
            'page'     => $page,
            'per_page' => $perPage,
            'offset'   => $offset,
        ]);

        /** @var GamesEntityCollection $games_collection */
        $games_collection = RepositoryFactory::get_repository()->get_games($criteria, $args);

        return $games_collection;
    }
}
