<?php

namespace FreedemoGames\Core\GamesSource\Collection;

use FreedemoGames\Core\GamesSource\Entities\GameEntity;

/**
 * Class GamesEntityCollection
 *
 * @package FreedemoGames\Core\GamesSource\Collection
 */
class GamesEntityCollection
{
    /** @var GameEntity[] */
    private array               $game_entities;
    private GamesCollectionMeta $meta;

    /**
     * @param GameEntity[]        $game_entities
     * @param GamesCollectionMeta $meta
     */
    public function __construct(array $game_entities, GamesCollectionMeta $meta)
    {
        $this->game_entities = $game_entities;
        $this->meta          = $meta;
    }

    /**
     * @return GameEntity[]
     */
    public function get_game_entities(): array
    {
        return $this->game_entities;
    }

    /**
     * @return GamesCollectionMeta
     */
    public function get_meta(): GamesCollectionMeta
    {
        return $this->meta;
    }
}
