<?php

declare(strict_types = 1);

namespace FreedemoGames\Core\GamesSource\Collection;

use FreedemoGames\Core\GamesSource\Entities\ProviderEntity;

/**
 * Class ProviderEntityCollection
 *
 * @package FreedemoGames\Core\GamesSource\Collection
 */
class ProviderEntityCollection
{
    /** @var ProviderEntity[] */
    private array $provider_entities = [];

    /**
     * @param ProviderEntity[] $provider_entities
     */
    public function __construct(?array $provider_entities)
    {
        if ($provider_entities) {
            foreach ($provider_entities as $provider) {
                $this->provider_entities[$provider->get_provider_id()] = $provider;
            }
        }
    }

    /**
     * @return ProviderEntity[]
     */
    public function get_provider_entities(): array
    {
        return $this->provider_entities;
    }

    /**
     * @param int $provider_id
     *
     * @return ProviderEntity|null
     */
    public function get_provider_by_id(int $provider_id): ?ProviderEntity
    {
        return $this->provider_entities[$provider_id] ?? null;
    }
}
