<?php

namespace FreedemoGames\Core\GamesSource\Dto;

/**
 * Class GamesCriteriaDto
 *
 * @package FreedemoGames\Core\GamesSource\Dto
 * @property           $provider
 * @property           $type
 * @property           $filters
 * @property           $search
 * @property           $sort
 */
class GamesCriteriaDto
{
    private array $criteria;
    private array $args;

    public function __construct(array $criteria, array $args = [])
    {
        $this->criteria = $criteria;
        $this->args     = $args;
    }

    public function __get($prop)
    {
        return $this->criteria[$prop] ?? null;
    }

    public function __isset($prop): bool
    {
        return isset($this->criteria[$prop]);
    }

    public function get_args(): array
    {
        return $this->args;
    }

}
