<?php

namespace FreedemoGames\Core\GamesSource\Entities;

use FreedemoGames\Core\GamesSource\Entities\Vo\GameImageVo;

/**
 * Class GameEntity
 *
 * @package FreedemoGames\Core\GamesSource\Entities
 */
class GameEntity
{
    private string      $id;
    private int         $game_id;
    private string      $name;
    private int         $provider_id;
    private string      $slug;
    private ?string     $visibility_status;
    private GameImageVo $game_images;

    /**
     * @param string      $id
     * @param int         $game_id
     * @param string      $title
     * @param int         $provider_id
     * @param string      $slug
     * @param string|null $visibility_status
     * @param GameImageVo $game_images
     */
    public function __construct(
        string $id,
        int $game_id,
        string $title,
        int $provider_id,
        string $slug,
        ?string $visibility_status,
        GameImageVo $game_images
    ) {
        $this->id                = $id;
        $this->game_id           = $game_id;
        $this->name              = $title;
        $this->provider_id       = $provider_id;
        $this->slug              = $slug;
        $this->visibility_status = $visibility_status;
        $this->game_images       = $game_images;
    }

    public function get_id(): string
    {
        return $this->id;
    }

    public function get_game_id(): int
    {
        return $this->game_id;
    }

    public function get_name(): string
    {
        return $this->name;
    }

    public function get_provider_id(): int
    {
        return $this->provider_id;
    }

    public function get_slug(): string
    {
        return $this->slug;
    }

    public function getVisibilityStatus(): ?string
    {
        return $this->visibility_status;
    }

    public function get_game_images(): GameImageVo
    {
        return $this->game_images;
    }
}
