<?php

namespace FreedemoGames\Core\GamesSource\Entities;

use FreedemoGames\Core\GamesSource\Entities\Vo\ProviderImage;

/**
 * Class ProviderEntity
 *
 * @package FreedemoGames\Core\GamesSource\Entities
 */
class ProviderEntity
{
    private int            $term_id;
    private int            $provider_id;
    private string         $name;
    private string         $slug;
    private ?string        $link;
    private ?ProviderImage $image;
    private ?int           $parent_id;
    private ?int           $year_start;
    private ?int           $year_end;

    public function __construct(
        int $term_id,
        int $provider_id,
        string $name,
        string $slug,
        ?string $link,
        ?ProviderImage $image,
        ?int $parent_id,
        ?int $year_start,
        ?int $year_end
    ) {
        $this->term_id     = $term_id;
        $this->provider_id = $provider_id;
        $this->name        = $name;
        $this->slug        = $slug;
        $this->link        = $link;
        $this->image       = $image;
        $this->parent_id   = $parent_id;
        $this->year_start  = $year_start;
        $this->year_end    = $year_end;
    }

    /**
     * @return int
     */
    public function getTermId(): int
    {
        return $this->term_id;
    }

    /**
     * @return int
     */
    public function get_provider_id(): int
    {
        return $this->provider_id;
    }

    /**
     * @return string
     */
    public function get_name(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function get_slug(): string
    {
        return $this->slug;
    }

    /**
     * @return string|null
     */
    public function get_link(): ?string
    {
        return $this->link;
    }

    /**
     * @return ProviderImage|null
     */
    public function getImage(): ?ProviderImage
    {
        return $this->image;
    }

    /**
     * @return int|null
     */
    public function get_parent_id(): ?int
    {
        return $this->parent_id;
    }

    /**
     * @return int|null
     */
    public function get_year_start(): ?int
    {
        return $this->year_start;
    }

    /**
     * @return int|null
     */
    public function get_year_end(): ?int
    {
        return $this->year_end;
    }
}
