<?php

namespace FreedemoGames\Core\GamesSource\Entities\Vo;

/**
 * Class GameImage
 *
 * @package FreedemoGames\Core\GamesSource\Entities\Vo
 */
class GameImage
{
    private string $image_url;
    private bool   $is_main;

    /**
     * @param string $image_url
     * @param bool   $is_main
     */
    public function __construct(string $image_url, bool $is_main = false)
    {
        $this->image_url = $image_url;
        $this->is_main   = $is_main;
    }

    public function is_main(): bool
    {
        return $this->is_main;
    }

    /**
     * @return mixed
     */
    public function get_image_url(): string
    {
        return $this->image_url;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->get_image_url();
    }

}
