<?php
namespace FreedemoGames\Core\GamesSource\Entities\Vo;

/**
 * Class GameImageVo
 *
 * @package FreedemoGames\Core\GamesSource\Entities\Vo
 */
class GameImageVo
{

    private ?GameImage $main_image = null;
    /**
     * @var GameImage[]
     */
    private array $game_images;

    public function __construct(GameImage ...$game_images)
    {
        $this->game_images = $game_images;
        $this->determinate_main_image();
    }

    private function determinate_main_image()
    {
        // first image as a main by default
        if (count($this->game_images) > 0) {
            $this->main_image = $this->game_images[0];

            // try to find specific of main image and get first found
            foreach ($this->game_images as $image) {
                if ($image->is_main()) {
                    $this->main_image = $image;
                    break;
                }
            }
        }
    }

    public function get_main_image(): ?GameImage
    {
        return $this->main_image;
    }

    /**
     * @return GameImage[]
     */
    public function get_all_images(): array
    {
        return $this->game_images;
    }

}
