<?php

namespace FreedemoGames\Core\GamesSource;

use FreedemoGames\Core\GameValidatorService;
use FreedemoGames\Core\GamesSource\Entities\GameEntity;
use FreedemoGames\Core\GamesSource\Entities\Vo\GameImage;
use FreedemoGames\Core\GamesSource\Entities\Vo\GameImageVo;
use FreedemoGames\Core\GamesSource\Exceptions\InvalidGameArgumentsException;

use function FreedemoGames\fdg_img_url_no_image;

/**
 * Class GameBuilder
 */
class GameBuilder
{
    /**
     * @param int    $post_id
     * @param string $title
     * @param array  $args
     * @param array  $atts
     *
     * @return GameEntity
     * @throws InvalidGameArgumentsException
     */
    public static function build_game(int $post_id, string $title, array $args, array $atts = []): GameEntity
    {
        GameValidatorService::are_there_required_fields($args, true);

        return new GameEntity(
            $post_id,
            $args['fdg_game_id'],
            $title,
            $args['fdg_vendor_id'],
            $args['fdg_slug'],
            $args['fdg_visibility_status'],
            new GameImageVo(new GameImage($args['fdg_img'] ?? fdg_img_url_no_image()))
        );
    }
}
