<?php

namespace FreedemoGames\Core\GamesSource;

/**
 * Class RepositoryFactory
 *
 * @package FreedemoGames\Core\GamesSource
 */
class RepositoryFactory
{
    const REPOSITORIES = [
        'local' => RepositoryLocal::class,
        'api'   => RepositoryApi::class,
    ];
    private static ?RepositoryInterface $_current_repository = null;

    /**
     * @return RepositoryInterface|null
     */
    public static function get_repository()
    {
        if (self::$_current_repository === null) {
            self::$_current_repository = self::determinate_repository();
        }

        return self::$_current_repository;
    }

    private static function determinate_repository()
    {
        if (defined('FREEDEMOGAMES_CURRENT_REPOSITORY') && isset(self::REPOSITORIES[FREEDEMOGAMES_CURRENT_REPOSITORY])) {
            $class = self::REPOSITORIES[FREEDEMOGAMES_CURRENT_REPOSITORY];
        } else {
            // using api source as a default repository
            $class = self::REPOSITORIES['api'];
        }
        return new $class();
    }
}
