<?php

namespace FreedemoGames\Core\GamesSource;

use FreedemoGames\Core\GamesSource\Entities\GameEntity;
use FreedemoGames\Core\GamesSource\Dto\GamesCriteriaDto;
use FreedemoGames\Core\GamesSource\Collection\GamesEntityCollection;
use FreedemoGames\Core\GamesSource\Exceptions\GameDoesntExistException;
use FreedemoGames\Core\GamesSource\Collection\ProviderEntityCollection;
use FreedemoGames\Core\GamesSource\Exceptions\InvalidGameArgumentsException;

/**
 * Interface RepositoryInterface
 *
 * @package FreedemoGames\Core\GamesSource
 */
interface RepositoryInterface
{
    /**
     * @param GamesCriteriaDto $criteria
     * @param array            $args
     *
     * @return GamesEntityCollection
     */
    public function get_games(
        GamesCriteriaDto $criteria,
        array $args = []
    ): GamesEntityCollection;


    /**
     * @param array $atts
     *
     * @return GameEntity
     * @throws GameDoesntExistException
     * @throws InvalidGameArgumentsException
     */
    public function get_game(array $atts = []): GameEntity;

    /**
     * @param array $args
     *
     * @return ProviderEntityCollection
     */
    public function get_providers(array $args = []): ProviderEntityCollection;

}
