<?php

namespace FreedemoGames\Core;

/**
 * Class ImageService
 *
 * @package FreedemoGames\Core
 */
class ImageService
{
    const ORIENTATION = 'orientation';

    static function group_images_by_key(array $images, string $key): array
    {
        $grouped = [];
        foreach ($images as $img) {
            $orientation             = $img[$key] ?? 'unknown';
            $grouped[$orientation][] = $img;
        }

        return $grouped;
    }
}
