<?php

namespace FreedemoGames\Core;

/**
 * Class Render
 *
 * @package FreedemoGames\Core
 */
class Render
{
    /**
     * @param string $path
     * @param string $view_file_name
     * @param array  $args
     * @param bool   $absolute
     *
     * @return false|string
     */
    public static function render(
        string $path = '',
        string $view_file_name = '',
        array $args = [],
        bool $absolute = false
    ) {
        $base_path      = !$absolute ? FREEDEMOGAMES_PLUGIN_DIR : '';
        $origin_path    = self::clean_path($path);
        $view_file_name = $view_file_name ? self::clean_path($view_file_name) : '';
        $file           = $base_path . $origin_path . ($view_file_name ? '/' : '') . $view_file_name . '.php';
        $fallback       = '';

        if (!file_exists($file)) {
            trigger_error(
                "[FDG Template]: Template not found for $view_file_name.php in $origin_path path.",
                E_USER_WARNING
            );
            $fallback = $base_path . 'src/Admin/partials/default.php';
        }

        extract($args);
        ob_start();

        include $fallback ?: $file;

        return ob_get_clean();
    }

    private static function clean_path($path): string
    {
        return str_replace('.php', '', rtrim($path, '/'));
    }

    public static function render_admin(
        string $path = '',
        string $view_file_name = '',
        array $args = []
    ) {
        $admin_tmpl_path = '/src/Admin/' . self::clean_path($path);

        return self::render($admin_tmpl_path, $view_file_name, $args);
    }

    public static function render_public(
        string $path = '',
        string $view_file_name = '',
        array $args = []
    ) {
        $public_tmpl_path = self::clean_path($path);

        return self::render($public_tmpl_path, $view_file_name, $args);
    }
}
