<?php

namespace FreedemoGames\PublicSide;

use FreedemoGames\Core\Render;
use FreedemoGames\Core\GamesService;
use FreedemoGames\Core\ProvidersService;
use FreedemoGames\Core\ApiResponseWrapper;
use FreedemoGames\Core\GamesSource\Collection\GamesEntityCollection;

/**
 * Class PublicSideAjaxController
 *
 * @package FreedemoGames\PublicSide
 */
class PublicSideAjaxController
{
    public function init(): void
    {
        add_action('wp_ajax_fdgames_get_games', [$this, 'get_games']);
        add_action('wp_ajax_nopriv_fdgames_get_games', [$this, 'get_games']);
    }

    public function get_games()
    {
        /** @var GamesEntityCollection $games_collection */
        $games_collection     = GamesService::get_games();
        $providers_collection = ProvidersService::get_providers();


        $games = [];
        foreach ($games_collection->get_game_entities() as $game) {
            $games[] = Render::render_public('templates/partials/archives', 'game-card', [
                'game'                 => $game,
                'provider' => $providers_collection->get_provider_by_id($game->get_provider_id()),
            ]);
        }

        wp_send_json_success(
            ApiResponseWrapper::success('', [
                'games' => array_values($games),
            ])
        );
    }
}
