<?php
/**
 * @var array                    $atts
 * @var int                      $total
 * @var int                      $per_page
 * @var GamesEntityCollection    $games_collection
 * @var ProviderEntityCollection $providers_collection
 * @see PublicSideController
 */

use FreedemoGames\Core\Render;
use FreedemoGames\Core\GamesSource\Collection\GamesEntityCollection;
use FreedemoGames\Core\GamesSource\Collection\ProviderEntityCollection;

?>
<div class="fgames-cards-wrapper">
    <?php
    echo Render::render_public('templates/partials/archives', 'game-filters', [
        'atts'      => $atts,
        'providers' => $providers_collection->get_provider_entities(),
    ]);
    ?>
    <div class="fdgames-grid" data-atts="<?= esc_attr(json_encode($atts)); ?>">
        <?php
        if (count($games_collection->get_game_entities()) > 0) {
            foreach ($games_collection->get_game_entities() as $game) {
                echo Render::render_public('templates/partials/archives', 'game-card', [
                    'game'     => $game,
                    'provider' => $providers_collection->get_provider_by_id($game->get_provider_id()),
                ]);
            } ?>
            <?php
        } else { ?>
            <div class="freedemo-games-slots-not-found">
                <?= __('We couldn’t find any slots matching your search.', 'freedemo-games'); ?>
            </div>
            <?php
        } ?>
    </div>
    <?php
    echo Render::render_public('templates/partials/archives', 'game-pagination', [
        'atts'     => $atts,
        'total'    => $games_collection->get_meta()->get_total(),
        'per_page' => $per_page,
    ]);

    wp_reset_postdata(); ?>
</div>
