<?php
/**
 * @var GameEntity $game
 * @var string     $powered_by_logo fdg logo.
 * @see PublicSideController::embed_game Powered by text.
 */

use FreedemoGames\Core\Render;
use FreedemoGames\Core\GamesSource\Entities\GameEntity;

use function FreedemoGames\fdg_get_game_link;
use function FreedemoGames\fdg_get_widget_src;
use function FreedemoGames\fdg_get_powered_by_text;

$token    ??= null;
$backlink ??= true;
?>

<div class="freedemo-games-single-game-container">
    <?php
    do_action('freedemo-games/single_game/top');
    ?>
    <div class="freedemo-games-container">
        <?= Render::render('templates/partials/single', 'slot-header'); ?>
        <div class="fdgames-slot">
            <!-- Freedemo.games widget implementation -->
            <div class="freedemo-game-widget style-default" data-game-slug="<?= $game->get_slug() ?>"
                 data-token="<?= $token ?>" data-options-link="0"></div>
            <script src="<?= fdg_get_widget_src() ?>"></script>
            <?php
            if ($backlink): ?>
                <div class="fdgames-powered-block">
                    <?= sprintf(
                        '<span class="fdgames-powered-text">Powered by '
                        . '<a href="%s" target="_blank">%s</a>' .
                        '</span>',
                        fdg_get_game_link($game->get_slug()),
                        fdg_get_powered_by_text(),
                    ) ?>
                </div>
            <?php
            endif; ?>
        </div>
    </div>

    <?php
    do_action('freedemo-games/single_game/bottom'); ?>
</div>
