<?php
/**
 * @var GameEntity      $game
 * @var GameEntity|null $provider
 */

use FreedemoGames\Core\Render;
use FreedemoGames\Core\GamesSource\Entities\GameEntity;

use function FreedemoGames\fdg_game_link;

?>
<div class="fdgames-card">
    <?php
    echo
    fdg_game_link(
        [
            'game_id' => $game->get_id(),
        ],
        Render::render_public('templates/partials/archives', 'game-thumb', [
            'game' => $game,
        ])
    );
    ?>
    <div class="fdgames-card-content">
        <?php
        echo Render::render_public('templates/partials/archives', 'game-meta', [
            'game'     => $game,
            'provider' => $provider,
        ]);
        echo Render::render_public('templates/partials/archives', 'game-play-button', [
            'game' => $game,
        ]);
        ?>
    </div>
</div>
