<?php

use FreedemoGames\Core\GamesSource\Entities\ProviderEntity;
use FreedemoGames\Admin\PostCustomType\Types\FreedemoProviderTaxonomy;

/**
 * @var ProviderEntity[] $providers
 */
?>
<div class="fdgames-filters">
    <form id="fdgames-filters-form" action="" method="get"
          data-id="<?= md5(json_encode($atts ?? []) . esc_attr($_SERVER['REQUEST_URI'])); ?>">

        <input id="fdgames-name" class="fdgames-search"
               type="text" name="fdg-name"
               placeholder="<?php
               _e('Slots search', 'freedemo-games'); ?>"
               value="<?= esc_html($_GET['fdg-name'] ?? ''); ?>"/>

        <select id="fdgames-provider" class="slots-select-provider" name="<?= FreedemoProviderTaxonomy::TYPE_NAME; ?>"
                data-types="<?= isset($atts['provider']) ? esc_attr($atts['provider']) : ''; ?>">
            <option value=""><?php
                _e('All Providers', 'freedemo-games'); ?></option>
            <?php
            if (!empty($providers)) {
                $selected = (isset($_GET[FreedemoProviderTaxonomy::TYPE_NAME]) && !empty($_GET[FreedemoProviderTaxonomy::TYPE_NAME]))
                    ? $_GET[FreedemoProviderTaxonomy::TYPE_NAME]
                    : (isset($atts['provider']) ? esc_attr(
                        $atts['provider']
                    ) : '');

                foreach ($providers as $provider) {
                    ?>
                    <option value="<?= $provider->get_slug(); ?>"<?php
                    selected($selected, $provider->get_slug()); ?>><?= $provider->get_name(); ?></option>
                    <?php
                }
            }
            ?>
        </select>

        <select id="fdgames-sort" name="fdg-sort">
            <option value="<?= (isset($atts['order_by']) ? esc_attr($atts['order_by']) : 'new'); ?>"><?php
                _e('Sort By', 'freedemo-games'); ?></option>
<!--            <option value="new" --><?php //= selected(esc_attr($_GET['fdg-sort'] ?? ''), 'new'); ?><!-->--><?php
//                _e('Newest to oldest', 'freedemo-games'); ?><!--</option>-->
            <option value="az" <?= selected(esc_attr($_GET['fdg-sort'] ?? ''), 'az'); ?>><?php
                _e('A-Z', 'freedemo-games'); ?></option>
            <option value="za" <?= selected(esc_attr($_GET['fdg-sort'] ?? ''), 'za'); ?>><?php
                _e('Z-A', 'freedemo-games'); ?></option>
        </select>

    </form>
</div>
