<?php

/**
 * @var array                 $atts
 * @var int                   $total
 * @var int                   $per_page
 * @var GamesEntityCollection $games_collection
 */

use FreedemoGames\Core\GamesSource\Collection\GamesEntityCollection;

use function FreedemoGames\fdg_current_page;

$offset = $per_page * fdg_current_page();
?>
<div class="fdgames-load-more-container">
    <div class="fdgames-inthelist" data-viewed-games="<?= $offset; ?>" data-per-page="<?= $per_page; ?>" data-total="<?= $total; ?>">
        <?= sprintf(__('You have viewed %s of %s games!', 'freedemo-games'),
            '<span class="fdgames-viewed">'. min($offset, $total) .'</span>',
            '<span class="fdgames-total">' . $total . '</span>');
        ?>
    </div>

    <div class="fdgames-load-more" style="<?= $total < $offset ? 'display:none' : ''; ?>">
        <a class="fdgames-load-more-btn" title="<?= _e('Load More', 'freedemo-games'); ?>" href="#"
           data-current-page="<?= fdg_current_page(); ?>"><?= _e('Load More', 'freedemo-games'); ?></a>
    </div>
</div>

